/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.mongodb.internal.connection;

import net.impactdev.impactor.relocations.com.mongodb.bulk.InsertRequest;
import net.impactdev.impactor.relocations.com.mongodb.internal.connection.LegacyMessage;
import net.impactdev.impactor.relocations.com.mongodb.internal.connection.MessageSettings;
import net.impactdev.impactor.relocations.com.mongodb.internal.connection.OpCode;
import net.impactdev.impactor.relocations.com.mongodb.internal.connection.RequestMessage;
import net.impactdev.impactor.relocations.com.mongodb.internal.validator.CollectibleDocumentFieldNameValidator;
import net.impactdev.impactor.relocations.org.bson.io.BsonOutput;

class InsertMessage
extends LegacyMessage {
    private final InsertRequest insertRequest;

    InsertMessage(String collectionName, InsertRequest insertRequest, MessageSettings settings) {
        super(collectionName, OpCode.OP_INSERT, settings);
        this.insertRequest = insertRequest;
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput outputStream2) {
        this.writeInsertPrologue(outputStream2);
        int firstDocumentPosition = outputStream2.getPosition();
        this.addCollectibleDocument(this.insertRequest.getDocument(), outputStream2, new CollectibleDocumentFieldNameValidator());
        return new RequestMessage.EncodingMetadata(firstDocumentPosition);
    }

    private void writeInsertPrologue(BsonOutput outputStream2) {
        outputStream2.writeInt32(0);
        outputStream2.writeCString(this.getCollectionName());
    }
}

